---------------------------------------------------------------------
-- Load event data for this map first.  This will be needed in Visuals.lua
-- to load the appropriate event-specific Actors into the AFT there.
---------------------------------------------------------------------
SRT.EventData = LoadActor(THEME:GetPathB("Overworld", "overlay/Scenes/" .. SRT.ActiveMap .. "/event-data.lua"))

---------------------------------------------------------------------
-- Primary ActorFrame and children
---------------------------------------------------------------------
local t = Def.ActorFrame{
	InitCommand=function(self)
		self:xy(0,0)

		-- queue the next command so that we can actually GetTopScreen()
		self:queuecommand("Capture")
	end,
	CaptureCommand=function(self)
		-- attach our InputHandler to the TopScreen and pass it this ActorFrame
		-- so we can manipulate stuff more easily from there
		SCREENMAN:GetTopScreen():AddInputCallback( LoadActor("InputHandler.lua", self) )
	end,
	TransitionScreenCommand=function(self)
		SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen")
	end
}

t[#t+1] = LoadActor("Visuals.lua")

-- DialogBox, hidden unless needed
t[#t+1] = LoadActor(THEME:GetPathB("","_DialogBox.lua"), "#7452b5")

return t